/*------------------------------------------------------------------------------*
 * File Name: LabTalk Variables Editor 											*
 * Creation: CPY 07/01/2005														*
 * Purpose: Loose Dataset and other LT variables viewing and deleting			*
 * Copyright (c) Originlab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY									*
 * CPY QA70-7860 10/14/05 LT_VARS_EDIT_UPDATE									*
 * Jasmine 10/21/05 BOTTOM_PANE_MODIFICATION									*
 * Jasmine 10/24/05 REMOVE_CLEAR_BUTTON											*
 * Jasmine 10/25/05 VALUE_EDITING												*
 * Iris 06/22/2007 v8.0646 FIX_RUNTIME_ERR_WHEN_SHOW_OPERATION_GUI_TREE			*
 * Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG									*
 * Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG							*
 * Sim 02-23-2010 QA81-14106 SUPPORT_SESSION_LOOSE_DATASET						*
 *------------------------------------------------------------------------------*/
///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
//#define CLEAR_BUTTON	

#ifdef CLEAR_BUTTON
#define WM_USER_CLEARBTN_ENABLE 		(WM_USER + 1012)
#endif CLEAR_BUTTON
///End REMOVE_CLEAR_BUTTON
#define WM_USER_DELETEBTN_ENABLE 		(WM_USER + 1014)

#define STR_DLG_NAME 			"LTVarDlg"

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
//#define STR_PROPERTY_USER 		"User"
#define STR_PROPERTY_USER 		"Project"
#define STR_PROPERTY_SYSTEM 	"System"
//#define STR_SCOPE_GLOBAL 		"Global"
//#define STR_SCOPE_SESSION	 	"Session"
#define STR_PROPERTY_SESSION	"Session"
///---END QA81-14106 IMPROVE_ED_DIALOG

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
//#define STR_TYPE_NUMERAL	 	"Numeral"
#define STR_TYPE_NUMERAL	 	"Numeric"
#define STR_TYPE_DOUBLE		 	"Double"
#define STR_TYPE_CONST		 	"Const"
#define STR_TYPE_INT		 	"Integer"
#define STR_TYPE_STRING_REG		"String Register"
///---END QA81-14106 IMPROVE_ED_DIALOG
#define STR_TYPE_STRING		 	"String"
#define STR_TYPE_FUNCTION		"Function" ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
#define STR_TYPE_LOOSEDATASET 	"LooseDataSet"
#define STR_TYPE_TREE 			"Tree"
///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
#define STR_TYPE_RANGE 			"DataRange"
#define STR_TYPE_MACRO 			"Macro"
///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG

#define STR_FORMAT				"*10"
#define STR_SEPERATE_OF_DATASET_PLOT_INFO			", "

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
//enum {LDE_NAME, IDE_VALUE, LDE_TYPE, LDE_SUBTYPE, LDE_PROPERTY, LDE_PLOT_INFO, LDE_DESCRIPTION};
enum {LDE_NAME, IDE_VALUE, LDE_TYPE, LDE_PROPERTY, LDE_PLOT_INFO, LDE_DESCRIPTION};
///---END QA81-14106 IMPROVE_ED_DIALOG
enum {
	LTVAR_MENU_USER, 
	LTVAR_MENU_SYSTEM, 
		CMDWND_MENU_SEPARATOR_1,
	LTVAR_MENU_NUMERAL, 
	LTVAR_MENU_STRING,
	LTVAR_MENU_LOOSEDATA, 
	LTVAR_MENU_TREE, 
		CMDWND_MENU_SEPARATOR_2,
	LTVAR_MENU_UPDATE,
	
	LTVAR_MENU_LAST_ITEM = 10000
};
enum {
	PROPERTY_INVALID = -1, ///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	PROPERTY_USER = 0, 
	PROPERTY_SYSTEM,
	PROPERTY_SESSION, ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	
	PROPERTY_LAST_ITEM,
};
enum {
	TYPE_INVALID = -1, ///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	TYPE_NUMERAL = 0, 	//TYPE_NUMERAL includes Double,Integer etc.
	TYPE_STRING, 
	TYPE_LOOSEDATASET, 	//TYPE_LOOSEDATASET includes Double,Integer,Text etc.
	TYPE_TREE,
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	TYPE_STRING_REG,
	TYPE_FUNCTION,
	///---END QA81-14106 IMPROVE_ED_DIALOG
	///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	TYPE_RANGE,
	TYPE_MACRO,
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	
	TYPE_LAST_ITEM,
	
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	// detail numeric type
	TYPE_DOUBLE,
	TYPE_CONST,
	TYPE_INT,
	///---END QA81-14106 IMPROVE_ED_DIALOG
};

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
enum{
	SHOW_STATUS_PROPERTY,
	SHOW_STATUS_TYPE,
};
///---END QA81-14106 IMPROVE_ED_DIALOG

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
#define STR_SHOW_LIST_STATUS(_TYPE_) "VarListShowStatus"+_TYPE_
///---END QA81-14106 IMPROVE_ED_DIALOG

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
/*
//The context menu of LTVarListControl
class LTVarListMenu : public Menu
{
public:
	LTVarListMenu(bool bUserChecked = true, bool bSystemChecked = true, bool bDoubleChecked = true, bool bStringChecked = true,
					bool bLooseDataChecked = true, bool bTreeChecked = true)
	{
		m_nChoice = -1;
				
		Add(_L("User"), OnMenuItem,  MF_STRING | (bUserChecked ? MF_CHECKED: MF_UNCHECKED));
		Add(_L("System"), OnMenuItem,  MF_STRING | (bSystemChecked ? MF_CHECKED: MF_UNCHECKED));
		Add(NULL, EmptySepFunc, MF_SEPARATOR);		
		Add(_L("Numeral"), OnMenuItem,  MF_STRING | (bDoubleChecked ? MF_CHECKED: MF_UNCHECKED));
		Add(_L("String"), OnMenuItem,  MF_STRING | (bStringChecked ? MF_CHECKED: MF_UNCHECKED));
		Add(_L("LooseDataSet"), OnMenuItem,  MF_STRING | (bLooseDataChecked ? MF_CHECKED: MF_UNCHECKED));
		Add(_L("Tree"), OnMenuItem,  MF_STRING | (bTreeChecked ? MF_CHECKED: MF_UNCHECKED));
		Add(NULL, EmptySepFunc, MF_SEPARATOR);
		Add(_L("Update"), OnMenuItem);
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= LTVAR_MENU_USER && m_nChoice < LTVAR_MENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}


private:
	int	m_nChoice;
};
*/
///---END QA81-14106 IMPROVE_ED_DIALOG

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
//#define DlgLoadSetting(_ValName_, _Val_, _DefualtVal_, _DlgName_) \
	//{ \
		//DWORD _dwVal; \
		//if( !dlg_load_registry(_DlgName_, _ValName_, _dwVal) ) \
			//_dwVal = _DefualtVal_; \
		//_Val_ = _dwVal; \
	//}
//#define DlgSaveSetting(_ValName_, _Val_, _DlgName_) \
	//{ \
		//dlg_save_to_registry(_DlgName_, _ValName_, _Val_); \
	//}
///---END QA81-14106 IMPROVE_ED_DIALOG
	
class LTVarListControl : public GridListControl
{
public:
	LTVarListControl()
	{
	}
	
	void InitList(int nID, WndContainer& dlg)
	{
		Init(nID, dlg);
		
		Window wTemp(dlg.GetSafeHwnd());
		m_wndDlg = wTemp;
				
		SetGridLines(flexGridInset);//(flexGridNone);		
		SetExplorerBar(flexExSortShow);
		SetAllowSelection(true);	///If false , support single selete; else multi seletion
		SetSelection( flexSelectionListBox ); 
		SetEditable();// flexEDKbdMouse );	///Jasmine 10/25/05 VALUE_EDITING, may be flexEDKbdMouse later
		
		/// Max 07-11-05 CORRECT_LOCALIZATION
		//vector<string> vsColHeading = {"Name", "Value", "Type", "SubType", "Property", "Plot Info", "Description"};
		vector<string> vsColHeading;
		vsColHeading.Add(_L("Name"));
		vsColHeading.Add(_L("Value"));
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//vsColHeading.Add(_L("Type"));
		//vsColHeading.Add(_L("SubType"));
		//vsColHeading.Add(_L("Property"));
		vsColHeading.Add(_L("Data Type"));
		//vsColHeading.Add(_L("SubType"));
		//vsColHeading.Add(_L("Property"));
		vsColHeading.Add(_L("Variable Type"));
		///---END QA81-14106 IMPROVE_ED_DIALOG
		vsColHeading.Add(_L("Plot Info"));
		vsColHeading.Add(_L("Description"));
		//vsColHeading.Add(_L("Scope")); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		/// END CORRECT_LOCALIZATION
		SetupRowsCols(1, 0, -1, vsColHeading.GetSize());		
		for(int ii = 0; ii < vsColHeading.GetSize(); ii++)
			SetColHeading(ii, vsColHeading[ii]);
				
		reset();		
		//m_vnShowProp.SetSize(2);
		//m_vnShowType.SetSize(4);
		m_vnShowProp.SetSize(PROPERTY_LAST_ITEM);
		m_vnShowType.SetSize(TYPE_LAST_ITEM);
		m_vnShowProp = 1;
		m_vnShowType = 1;
		
		m_bUpdate = true;
		
	}
	//--- CPY QA70-7860 10/14/05 LT_VARS_EDIT_UPDATE
	// I added nVarType, should add code to do more efficient update based on var type change, not to always reload all
	void Update(int nVarType = -1) // -1 to update all
	{
		if(!m_bUpdate)
			return;
		
		bool bUser = true;
		if(-1 == nVarType)
		{
			bUser = false;
			reset();
		}
		else
		{	//only available for user-defined variables
			//delete old
			string strType = getTypeName(nVarType);
			for(int nIndex = 0; nIndex > -1; )
			{
				if(!m_vsName.GetSize())
					break;
				///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
				//nIndex = m_vsType.Find(strType, nIndex);
				if ( STR_TYPE_NUMERAL == strType )
				{
					StringArray saTypes = {STR_TYPE_NUMERAL, STR_TYPE_DOUBLE, STR_TYPE_CONST, STR_TYPE_INT};
					nIndex = string_array_find_one_of(m_vsType, saTypes, nIndex);
				}
				else
				{
					nIndex = m_vsType.Find(strType, nIndex);
				}
				///---END QA81-14106 IMPROVE_ED_DIALOG
				if(-1 == nIndex)
					break;
				if(m_vsProperty[nIndex].CompareNoCase(STR_PROPERTY_SYSTEM))
					deleteFromDlg(m_vsName[nIndex], m_vsType[nIndex]);
				else
					nIndex++;
			}
		}		
		//get new		 
		loadLTVar(nVarType, bUser);
		show();
		return;			
		
	}
	
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/*
	BOOL OnCmdWndMenu(int nx, int ny)
	{
		int				nCmd; 
		LTVarListMenu 	myMenu(GetShowProp(PROPERTY_USER), GetShowProp(PROPERTY_SYSTEM), GetShowType(TYPE_NUMERAL), GetShowType(TYPE_STRING), GetShowType(TYPE_LOOSEDATASET), GetShowType(TYPE_TREE));
		
		myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
		if(myMenu.GetCommand(nCmd))
		{
			switch(nCmd)
			{				
			case LTVAR_MENU_USER:
				Toggle(m_vnShowProp[PROPERTY_USER]);
				break;
				
			case LTVAR_MENU_SYSTEM: 
				Toggle(m_vnShowProp[PROPERTY_SYSTEM]);
				break;
				
			case LTVAR_MENU_NUMERAL:
				Toggle(m_vnShowType[TYPE_NUMERAL]);
				break;
			case LTVAR_MENU_STRING: 
				Toggle(m_vnShowType[TYPE_STRING]);
				break;
				
			case LTVAR_MENU_LOOSEDATA: 
				Toggle(m_vnShowType[TYPE_LOOSEDATASET]);
				break;
				
			case LTVAR_MENU_TREE:
				Toggle(m_vnShowType[TYPE_TREE]);
				break;
				
			case LTVAR_MENU_UPDATE:
				Update();
				return TRUE;
			default:
				return FALSE;
			}
			show();
			return TRUE;
		}	
		return FALSE;
	}
	*/
	void UpdateShow()
	{
		show();
	}
	///---END QA81-14106 IMPROVE_ED_DIALOG
	///Jasmine 10/20/05 BOTTOM_PANE_MODIFICATION
	/*
	void RowChange(vector<string>& vsVars, vector<string>& vsTypes)
	{
		if(!IsReady())
			return;
		
		vector<uint> vnSels;
		if(!GetSelRows(vnSels) || vnSels.GetSize() < 1)
			return;
				
		int nCount = vnSels.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{
			string strVar = GetCell(vnSels[ii], LDE_NAME+1);
			string strType = GetCell(vnSels[ii], LDE_TYPE+1);
			if(STR_TYPE_LOOSEDATASET== strType || STR_TYPE_TREE== strType)
			{
				vsVars.Add(strVar);
				vsTypes.Add(strType);
			}
		}		
		///set button status
		bool bDeleteButton;
		for(ii = 0; ii < nCount; ii++)
		{
			string strProperty = GetCell(vnSels[ii], LDE_PROPERTY+1);
			if(STR_PROPERTY_SYSTEM == strProperty)
			{
				bDeleteButton = false;//need some change 
				break;
			}
		}
		if(ii == nCount)
			bDeleteButton = true;
		m_wndDlg.PostMessage(WM_USER_DELETEBTN_ENABLE, bDeleteButton);		
	}
	*/
	//int CheckSelVar(TreeNode& trVar)///Jasmine 10/24/05 BOTTOM_PANE_MODIFICATION
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	//int CheckSelVar(vector<string>& vsVars)
	///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	//int CheckSelVar(vector<string>& vsVars, BOOL *pbSystem = NULL)
	int CheckSelVar(vector<string>& vsVars, int *pnProperty = NULL)
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	///---END QA81-14106 IMPROVE_ED_DIALOG
	{
		///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		if(!IsReady())
			//return -1;
			return TYPE_INVALID;
		
		/*
		vector<uint> vnSels;
		if(!GetSelRows(vnSels) || vnSels.GetSize() < 1)
			return -1;
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		//int nCount = vnSels.GetSize(), nType;
		int nCount = vnSels.GetSize();
		int nType = TYPE_INVALID; 
		int nProperty = PROPERTY_INVALID;
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		//if(trVar)///Jasmine 10/24/05 BOTTOM_PANE_MODIFICATION
			//trVar.Reset();
		for(int ii = 0; ii < nCount; ii++)
		{
			string strVar = GetCell(vnSels[ii], LDE_NAME+GetColOffset());
			string strType = GetCell(vnSels[ii], LDE_TYPE+GetColOffset());
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			string strProperty = GetCell(vnSels[ii], LDE_PROPERTY+GetColOffset());
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
			//only for Dataset and Tree
			if(!strType.CompareNoCase(STR_TYPE_LOOSEDATASET))
			{
				///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
				if ( TYPE_INVALID != nType && TYPE_LOOSEDATASET != nType )
				{
					vsVars.SetSize(0);
					nType = TYPE_INVALID;
					break;
				}
				///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
				//addDataset(trVar, strVar);///Jasmine 10/24/05 BOTTOM_PANE_MODIFICATION
				vsVars.Add(strVar);				
				nType = TYPE_LOOSEDATASET;
			}
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			if(!strType.CompareNoCase(STR_TYPE_RANGE))
			{
				///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
				if ( TYPE_INVALID != nType && TYPE_RANGE != nType )
				{
					vsVars.SetSize(0);
					nType = TYPE_INVALID;
					break;
				}
				///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
				vsVars.Add(strVar);				
				nType = TYPE_RANGE;
			}
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
			if(!strType.CompareNoCase(STR_TYPE_TREE))
			{
				///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
				if ( TYPE_INVALID != nType && TYPE_TREE != nType )
				{
					vsVars.SetSize(0);
					nType = TYPE_INVALID;
					break;
				}
				if ( nCount > 1 ) // only support single selection
					break;
				
				// to do
				// now only support show project tree view
				if ( ! (0 == strProperty.CompareNoCase(STR_PROPERTY_USER) ) )
					break;				
				///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
				//bool flag = Project.GetTree(strVar, trVar);///Jasmine 10/24/05 BOTTOM_PANE_MODIFICATION
				vsVars.SetSize(1);
				vsVars[0] = strVar;
				nType = TYPE_TREE;
				break;
			}
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			if(!strType.CompareNoCase(STR_TYPE_FUNCTION))
			{
				///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
				if ( TYPE_INVALID != nType && TYPE_FUNCTION != nType )
				{
					vsVars.SetSize(0);
					nType = TYPE_INVALID;
					break;
				}
				if ( nCount > 1 ) // only support single selection
					break;
				///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
				vsVars.SetSize(1);
				vsVars[0] = strVar;
				nType = TYPE_FUNCTION;
				break;
			}
			///---END QA81-14106 IMPROVE_ED_DIALOG
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			if(!strType.CompareNoCase(STR_TYPE_MACRO))
			{
				///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
				if ( TYPE_INVALID != nType && TYPE_MACRO != nType )
				{
					vsVars.SetSize(0);
					nType = TYPE_INVALID;
					break;
				}
				if ( nCount > 1 ) // only support single selection
					break;
				///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
				vsVars.SetSize(1);
				vsVars[0] = strVar;
				nType = TYPE_MACRO;
				break;
			}
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}			
		
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		///set button status
		//bool bDeleteButton;
		bool bSystem = false;
		for(ii = 0; ii < nCount; ii++)
		{
			string strProperty = GetCell(vnSels[ii], LDE_PROPERTY+GetColOffset());
			if(STR_PROPERTY_SYSTEM == strProperty)
			{
				//bDeleteButton = false;
				bSystem = true;
				break;
			}
		}
		//if(ii == nCount)
			//bDeleteButton = true;
		
		//m_wndDlg.PostMessage(WM_USER_DELETEBTN_ENABLE, bDeleteButton);
		if ( pbSystem )
			*pbSystem = bSystem;
		///---END QA81-14106 IMPROVE_ED_DIALOG
		*/
		int nType; 
		int nProperty;
		
		bool bSame = false;
		bSame = ( bSame || is_all_sel_same_class(vsVars, (nType = TYPE_LOOSEDATASET),	(nProperty = PROPERTY_USER),	true) );
		bSame = ( bSame || is_all_sel_same_class(vsVars, (nType = TYPE_LOOSEDATASET),	(nProperty = PROPERTY_SESSION),	true) ); ///---Sim 02-23-2010 QA81-14106 SUPPORT_SESSION_LOOSE_DATASET
		bSame = ( bSame || is_all_sel_same_class(vsVars, (nType = TYPE_RANGE),			(nProperty = PROPERTY_SESSION),	true) );
		bSame = ( bSame || is_all_sel_same_class(vsVars, (nType = TYPE_TREE),			(nProperty = PROPERTY_USER),	false) );
		bSame = ( bSame || is_all_sel_same_class(vsVars, (nType = TYPE_TREE),			(nProperty = PROPERTY_SESSION),	false) );
		bSame = ( bSame || is_all_sel_same_class(vsVars, (nType = TYPE_FUNCTION),		(nProperty = PROPERTY_SESSION), false) );
		bSame = ( bSame || is_all_sel_same_class(vsVars, (nType = TYPE_MACRO), 			(nProperty = PROPERTY_SESSION), false) );
		
		if ( !bSame )
			return TYPE_INVALID;
		
		if ( pnProperty )
			*pnProperty = nProperty;
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		
		return nType;
	}
	///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	bool IsSystemVarSelected()
	{
		vector<uint> vnSels;
		if( !GetSelRows(vnSels) )
			return false;
			
		bool bSystem = false;
		for(int ii = 0; ii < vnSels.GetSize(); ii++)
		{
			string strProperty = GetCell(vnSels[ii], LDE_PROPERTY+GetColOffset());
			if(STR_PROPERTY_SYSTEM == strProperty)
			{
				bSystem = true;
				break;
			}
		}
		return bSystem;
	}
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	///End BOTTOM_PANE_MODIFICATION
///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
#ifdef CLEAR_BUTTON
	void ClearVars()
	{
		string strWarning = _L("Variables shown in" + "" + STR_DLG_NAME + "" + _L("will be totally deleted!");
		if(IDCANCEL == MessageBox(m_wndDlg.GetSafeHwnd(), strWarning, _L("Attention!"), MB_OKCANCEL | MB_DEFBUTTON2 | MB_ICONEXCLAMATION))
			return;
		
		if( GetRows() <= GetRowOffset())
			return;
		for(int ii = GetRows()-1; ii >= GetRowOffset() ; ii--)
			deleteVar(ii);
		
	}
#endif CLEAR_BUTTON
///End REMOVE_CLEAR_BUTTON
	void DeleteVars()
	{
		m_bUpdate = false;
		vector<uint> vnSels;
		if(!GetSelRows(vnSels) || vnSels.GetSize() < 1)
			return;
		
		for(int ii = vnSels.GetSize()-1; ii >= 0 ; ii--)
			deleteVar(vnSels[ii]);
		m_bUpdate = true;
	}
	bool GetShowProp(int nBit)
	{
		if(m_vnShowProp[nBit])
			return true;
		return false;
	}
	bool GetShowType(int nBit)
	{
		if(m_vnShowType[nBit])
			return true;
		return false;
	}
	void Toggle(int& nn)
	{
		nn = nn? 0:1;
	}
	
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/*
	int GetVarListShowStatus()//get the show status into an integer
	{
		int nShowStatus = 0;	
		for(int ii = 5; ii >= 0; ii--)
		{
			if(4 <= ii)
				nShowStatus += m_vnShowProp[ii-4]*(10^ii);
			else
				nShowStatus += m_vnShowType[ii]*(10^ii);
		}
		return 	nShowStatus;
	}
	void SetVarListShowStatus(int nShowStatus)//set the show status with the digits of the integer
	{
		for(int ii = 6; ii >0; ii--)
		{
			if(5 <= ii)
				m_vnShowProp[ii-5] = getDigit(nShowStatus, ii);
			else
				m_vnShowType[ii-1] = getDigit(nShowStatus, ii);
		}
	}
	*/
	/*
	void LoadVarListShowStatus(LPCSTR lpcszDlgName)
	{
		DlgLoadSetting(STR_SHOW_LIST_STATUS("User"),			m_vnShowProp[PROPERTY_USER],		TRUE,	lpcszDlgName);
		DlgLoadSetting(STR_SHOW_LIST_STATUS("System"),			m_vnShowProp[PROPERTY_SYSTEM],		TRUE,	lpcszDlgName);
		
		DlgLoadSetting(STR_SHOW_LIST_STATUS("Numeric"),			m_vnShowType[TYPE_NUMERAL],			TRUE,	lpcszDlgName);
		DlgLoadSetting(STR_SHOW_LIST_STATUS("String"),			m_vnShowType[TYPE_STRING],			TRUE,	lpcszDlgName);
		DlgLoadSetting(STR_SHOW_LIST_STATUS("LooseDataset"),	m_vnShowType[TYPE_LOOSEDATASET],	TRUE,	lpcszDlgName);
		DlgLoadSetting(STR_SHOW_LIST_STATUS("Tree"),			m_vnShowType[TYPE_TREE],			TRUE,	lpcszDlgName);
		DlgLoadSetting(STR_SHOW_LIST_STATUS("StringRegister"),	m_vnShowType[TYPE_STRING_REG],		TRUE,	lpcszDlgName);
		DlgLoadSetting(STR_SHOW_LIST_STATUS("Function"),		m_vnShowType[TYPE_FUNCTION],		TRUE,	lpcszDlgName);
	}
	void SaveVarListShowStatus(LPCSTR lpcszDlgName)
	{
		DlgSaveSetting(STR_SHOW_LIST_STATUS("User"),			m_vnShowProp[PROPERTY_USER],		lpcszDlgName);
		DlgSaveSetting(STR_SHOW_LIST_STATUS("System"),			m_vnShowProp[PROPERTY_SYSTEM],		lpcszDlgName);
		
		DlgSaveSetting(STR_SHOW_LIST_STATUS("Numeric"),			m_vnShowType[TYPE_NUMERAL],			lpcszDlgName);
		DlgSaveSetting(STR_SHOW_LIST_STATUS("String"),			m_vnShowType[TYPE_STRING],			lpcszDlgName);
		DlgSaveSetting(STR_SHOW_LIST_STATUS("LooseDataset"),	m_vnShowType[TYPE_LOOSEDATASET],	lpcszDlgName);
		DlgSaveSetting(STR_SHOW_LIST_STATUS("Tree"),			m_vnShowType[TYPE_TREE],			lpcszDlgName);
		DlgSaveSetting(STR_SHOW_LIST_STATUS("StringRegister"),	m_vnShowType[TYPE_STRING_REG],		lpcszDlgName);
		DlgSaveSetting(STR_SHOW_LIST_STATUS("Function"),		m_vnShowType[TYPE_FUNCTION],		lpcszDlgName);
	}
	*/
	int		GetVarListShowStatus(int nID, int nCategory)
	{
		int nVal = -1;
		switch (nCategory)
		{
		case SHOW_STATUS_PROPERTY:
			if ( 0 <= nID && nID < PROPERTY_LAST_ITEM )
				nVal = m_vnShowProp[nID];
			else
				error_report("Show Status ID out of range!");
			break;
		case SHOW_STATUS_TYPE:
			if ( 0 <= nID && nID < TYPE_LAST_ITEM )
				nVal = m_vnShowType[nID];
			else
				error_report("Show Status ID out of range!");
			break;
		}
		
		return nVal;
	}
	void	SetVarListShowStatus(int nShowStatus, int nID, int nCategory)
	{
		switch (nCategory)
		{
		case SHOW_STATUS_PROPERTY:
			if ( 0 <= nID && nID < PROPERTY_LAST_ITEM )
				m_vnShowProp[nID] = nShowStatus;
			else
				error_report("Show Status ID out of range!");
			break;
		case SHOW_STATUS_TYPE:
			if ( 0 <= nID && nID < TYPE_LAST_ITEM )
				m_vnShowType[nID] = nShowStatus;
			else
				error_report("Show Status ID out of range!");
			break;
		}
	}
	///---END QA81-14106 IMPROVE_ED_DIALOG
	
protected:	

private:
	void reset()
	{
		m_vsName.SetSize(0);
		m_vsValue.SetSize(0);
		m_vsType.SetSize(0);
		m_vsSubType.SetSize(0);
		m_vsProperty.SetSize(0);
		m_vsPlotInfo.SetSize(0);
		m_vsDescription.SetSize(0);
		m_vsScope.SetSize(0); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	}
	void loadLTVar(int nType = -1, bool bUserOnly = false)
	{
		string 	strProperty;
		int 	nCount, nAllCount;
		
		if(-1 == nType || TYPE_NUMERAL == nType)	//get Labtalk numerical variable
		{
			vector<string> vsLTVar;
			vector 		   vdValues;
			vector<int>	   vnTypes;
			nCount    = Project.GetLTVars(vsLTVar, vdValues, TRUE, vnTypes);
			nAllCount = Project.GetLTVars(vsLTVar, vdValues, bUserOnly, vnTypes);
			strProperty = STR_PROPERTY_SYSTEM;
			for(int ii = 0; ii < nAllCount; ii++)
			{
				if(nAllCount - nCount == ii)	//user's numerical variable is after system variable
					 strProperty = STR_PROPERTY_USER;
				///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
				//addLTVarInfo(vsLTVar[ii], ftoa(vdValues[ii], STR_FORMAT), getTypeName(TYPE_NUMERAL), getVarTypeName(vnTypes[ii]), strProperty);
				addLTVarInfo(vsLTVar[ii], ftoa(vdValues[ii], STR_FORMAT), getTypeName(TYPE_DOUBLE), "", strProperty);
				///---END QA81-14106 IMPROVE_ED_DIALOG
			}
			
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			vector<string> vsValues;
			
			nCount = Project.GetSessionLTVars(vsLTVar, vsValues, LTVAR_TYPE_VAR_DOUBLE);
			for (ii = 0; ii < nCount; ii++)
			{
				//addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_NUMERAL), getVarTypeName(FSI_DOUBLE), STR_PROPERTY_USER, "", "", STR_SCOPE_SESSION);
				addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_DOUBLE), "", STR_PROPERTY_SESSION);
			}
			
			nCount = Project.GetSessionLTVars(vsLTVar, vsValues, LTVAR_TYPE_VAR_CONST);
			for (ii = 0; ii < nCount; ii++)
			{
				//addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_NUMERAL), getVarTypeName(FSI_DOUBLE), STR_PROPERTY_USER, "", "", STR_SCOPE_SESSION);
				addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_CONST), "", STR_PROPERTY_SESSION);
			}
			
			nCount = Project.GetSessionLTVars(vsLTVar, vsValues, LTVAR_TYPE_VAR_INT);
			for (ii = 0; ii < nCount; ii++)
			{
				//addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_NUMERAL), getVarTypeName(FSI_SHORT), STR_PROPERTY_USER, "", "", STR_SCOPE_SESSION);
				addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_INT), "", STR_PROPERTY_SESSION);
			}
			
			///---END QA81-14106 IMPROVE_ED_DIALOG
		}
		if(-1 == nType || TYPE_STRING == nType)	//get Labtalk string user variable
		{
			vector<string> vsLTStrVar, vsLTStrVar2, vsValues;
			nCount = Project.GetLTStrVars(vsLTStrVar, vsValues, TRUE);
			//get Labtalk string system variable
			nAllCount = Project.GetLTStrVars(vsLTStrVar2, vsValues, bUserOnly);
			for(int ii = 0; ii < nAllCount; ii++)
			{
				strProperty = STR_PROPERTY_USER;
				if(-1 == vsLTStrVar.Find(vsLTStrVar2[ii]))
					strProperty = STR_PROPERTY_SYSTEM;
				//addLTVarInfo(vsLTStrVar2[ii], vsValues[ii], getTypeName(TYPE_STRING), getVarTypeName(FSI_TEXT), strProperty);
				addLTVarInfo(vsLTStrVar2[ii], vsValues[ii], getTypeName(TYPE_STRING), "", strProperty);
			}	
			
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			vector<string> vsLTVar;
			
			nCount = Project.GetSessionLTVars(vsLTVar, vsValues, LTVAR_TYPE_VAR_STR);
			for (ii = 0; ii < nCount; ii++)
			{
				//addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_STRING), getVarTypeName(FSI_TEXT), STR_PROPERTY_USER, "", "", STR_SCOPE_SESSION);
				addLTVarInfo(vsLTVar[ii], vsValues[ii], getTypeName(TYPE_STRING), "", STR_PROPERTY_SESSION);
			}
			///---END QA81-14106 IMPROVE_ED_DIALOG
		}
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		if(-1 == nType || TYPE_STRING_REG == nType)	//get Labtalk global string variable
		{
			char bufGVarValue[MAXFULLPATH];
			for ( char chGVar = 'A'; chGVar <= 'Z'; chGVar++ )
			{
				string strGVar = "%" + chGVar;				
				LT_get_str(strGVar, bufGVarValue, MAXFULLPATH);
				addLTVarInfo(strGVar, bufGVarValue, getTypeName(TYPE_STRING_REG), "", STR_PROPERTY_SYSTEM);
			}
		}
		if(-1 == nType || TYPE_FUNCTION == nType)
		{
			vector<string> vsLTVar, vsValues;
			nCount = Project.GetSessionLTVars(vsLTVar, NULL, LTVAR_TYPE_VAR_FUNCTION);
			for(int ii = 0; ii < nCount; ii++)
			{
				//addLTVarInfo(vsLTVar[ii], "", getTypeName(TYPE_FUNCTION), "", STR_PROPERTY_USER, "", "", STR_SCOPE_SESSION);
				addLTVarInfo(vsLTVar[ii], "", getTypeName(TYPE_FUNCTION), "", STR_PROPERTY_SESSION);
			}	
		}
		///---END QA81-14106 IMPROVE_ED_DIALOG
		if(-1 == nType || TYPE_LOOSEDATASET == nType)	//get LooseDataSet
		{
			int nType = -1, nSize;
			string strPlotInfo;
			foreach(string strName in Project.LooseDatasetNames)
			{
				nType = HIWORD(Project.GetDatasetInfo(strName, true));
				nSize = getDatasetSize(strName);
				strPlotInfo = getDatasetPlotInfo(strName);
				//type should change from "LooseDataSet" to "long", "int" etc. doing...
				///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
				//addLTVarInfo(strName, "<1x"+(string)nSize+">", getTypeName(TYPE_LOOSEDATASET), getVarTypeName(nType), STR_PROPERTY_USER, strPlotInfo);
				addLTVarInfo(strName, "<1x"+(string)nSize+">", getTypeName(TYPE_LOOSEDATASET), "", STR_PROPERTY_USER, strPlotInfo);
				///---END QA81-14106 IMPROVE_ED_DIALOG
			}
			
			///---Sim 02-23-2010 QA81-14106 SUPPORT_SESSION_LOOSE_DATASET
			vector<string> vsLTVar, vsValues;
			nCount = Project.GetSessionLTVars(vsLTVar, NULL, LTVAR_TYPE_VAR_LOOSE_DATASET);
			for(int ii = 0; ii < nCount; ii++)
			{
				nSize = getDatasetSize(strName);
				strPlotInfo = getDatasetPlotInfo(strName);
				addLTVarInfo(vsLTVar[ii], "<1x"+(string)nSize+">", getTypeName(TYPE_LOOSEDATASET), "", STR_PROPERTY_SESSION, strPlotInfo);
			}	
			///---END QA81-14106 SUPPORT_SESSION_LOOSE_DATASET
		}
		if(-1 == nType || TYPE_TREE == nType)	//get tree
		{
			vector<string> vsTreeNames;
			nCount = Project.GetTreeNames(vsTreeNames);
			for(int ii = 0; ii < nCount; ii++)
				///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
				//addLTVarInfo(vsTreeNames[ii], "", getTypeName(TYPE_TREE), getVarTypeName(FSI_MIXED));			
				addLTVarInfo(vsTreeNames[ii], "", getTypeName(TYPE_TREE), "");
				///---END QA81-14106 IMPROVE_ED_DIALOG
			
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			nCount = Project.GetSessionLTVars(vsTreeNames, NULL, LTVAR_TYPE_VAR_TREE);
			for( ii = 0; ii < nCount; ii++ )
				addLTVarInfo(vsTreeNames[ii], "", getTypeName(TYPE_TREE), "", STR_PROPERTY_SESSION);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		if(-1 == nType || TYPE_RANGE == nType)
		{
			vector<string> vsLTVar, vsValues;
			nCount = Project.GetSessionLTVars(vsLTVar, NULL, LTVAR_TYPE_VAR_ALIAS);
			for(int ii = 0; ii < nCount; ii++)
			{
				addLTVarInfo(vsLTVar[ii], "", getTypeName(TYPE_RANGE), "", STR_PROPERTY_SESSION);
			}	
		}
		if(-1 == nType || TYPE_MACRO == nType)
		{
			vector<string> vsLTVar, vsValues;
			nCount = Project.GetMacros(vsLTVar, NULL);
			for(int ii = 0; ii < nCount; ii++)
			{
				addLTVarInfo(vsLTVar[ii], "", getTypeName(TYPE_MACRO), "", STR_PROPERTY_SESSION);
			}	
		}
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	}
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	//void addLTVarInfo(string strName, string strValue, string strType, string strSubType, string strProperty=STR_PROPERTY_USER, string strPlotInfo="", string strDescpt="")
	//void addLTVarInfo(string strName, string strValue, string strType, string strSubType, string strProperty=STR_PROPERTY_USER, string strPlotInfo="", string strDescpt="", string strScope=STR_SCOPE_GLOBAL)
	void addLTVarInfo(string strName, string strValue, string strType, string strSubType, string strProperty=STR_PROPERTY_USER, string strPlotInfo="", string strDescpt="")
	///---END QA81-14106 IMPROVE_ED_DIALOG
	{
		m_vsName.Add(strName);
		m_vsValue.Add(strValue);
		m_vsType.Add(strType);
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//m_vsSubType.Add(strSubType);
		m_vsSubType.Add("");
		///---END QA81-14106 IMPROVE_ED_DIALOG
		m_vsProperty.Add(strProperty);
		m_vsPlotInfo.Add(strPlotInfo);
		m_vsDescription.Add(strDescpt);
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//m_vsScope.Add(strScope);
		m_vsScope.Add("");
		///---END QA81-14106 IMPROVE_ED_DIALOG
	}
	string getTypeName(int nType)
	{
		string str;
		switch(nType)
		{
		case TYPE_NUMERAL :
			str = STR_TYPE_NUMERAL;
			break;
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		case TYPE_DOUBLE :
			str = STR_TYPE_DOUBLE;
			break;
		case TYPE_CONST :
			str = STR_TYPE_CONST;
			break;
		case TYPE_INT :
			str = STR_TYPE_INT;
			break;
		///---END QA81-14106 IMPROVE_ED_DIALOG
		case TYPE_STRING:
			str = STR_TYPE_STRING;
			break;
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		case TYPE_STRING_REG:
			str = STR_TYPE_STRING_REG;
			break;
		case TYPE_FUNCTION:
			str = STR_TYPE_FUNCTION;
			break;
		///---END QA81-14106 IMPROVE_ED_DIALOG
		case TYPE_LOOSEDATASET:
			str = STR_TYPE_LOOSEDATASET;
			break;
		case TYPE_TREE:
			str = STR_TYPE_TREE;
			break;
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		case TYPE_RANGE:
			str = STR_TYPE_RANGE;
			break;
		case TYPE_MACRO:
			str = STR_TYPE_MACRO;
			break;
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		default:
			str="";
			break;
		}
		return str;
	}
	///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	string getPropertyName(int nProperty)
	{
		string str;
		switch(nProperty)
		{
		case PROPERTY_USER :
			str = STR_PROPERTY_USER;
			break;
		case PROPERTY_SYSTEM :
			str = STR_PROPERTY_SYSTEM;
			break;
		case PROPERTY_SESSION :
			str = STR_PROPERTY_SESSION;
			break;
		default:
			str="";
			break;
		}
		return str;
	}
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	string getVarTypeName(int nType)
	{
		string str;
		switch(nType)
		{
		case FSI_DOUBLE:
			str = "Double";
			break;
		case FSI_REAL:
			str = "Float";
			break;
		case FSI_SHORT:
			str = "Integer";
			break;
		case FSI_LONG:
			str = "Long";
			break;
		case FSI_CHAR:
			str = "Char";
			break;
		case FSI_TEXT:
			str = "Text";
			break;
		case FSI_MIXED:
			str = "Text & Numeric";
			break;
		case FSI_BYTE:
			str = "Byte";
			break;
		case FSI_USHORT:
			str = "UShort";
			break;
		case FSI_ULONG:
			str = "ULong";
			break;
		case FSI_COMPLEX:
			str = "Complex";
			break;
		default:
			str="";
			break;
		}
		return str;
	}
	double getDatasetSize( LPCSTR lpcszName )
	{
		string strLT;
		strLT.Format("get %s -e v1", lpcszName);
		LT_execute(strLT);
		double vv;
		LT_get_var("v1", &vv);
		return vv;
	}
	string getDatasetPlotInfo(LPCSTR lpcszName)
	{
		string strPlotInfo;
		
		if(lpcszName == NULL)
			return strPlotInfo;
		
		vector<string> vsGraphNames;
		vector<int> vnLayers;
		vector<int> vnPlotDesignations;
		
		int nn= Project.GetDatasetPlotList(lpcszName, vsGraphNames, vnLayers, vnPlotDesignations);
		if(nn <= 0 )
			return strPlotInfo;		
		
		string strSeperate = STR_SEPERATE_OF_DATASET_PLOT_INFO;
		for(int ii = 0; ii < nn; ii++)
		{
			char szTemp[NAME_SIZE];
			if(!get_plot_designation_str(vnPlotDesignations[ii], szTemp, NAME_SIZE))
				lstrcpy(szTemp, "Unknown");

			if(ii > 0)
				strPlotInfo += STR_SEPERATE_OF_DATASET_PLOT_INFO;

			strPlotInfo +=  vsGraphNames[ii] + "." + (1+vnLayers[ii]) + "(" + szTemp + ")";
		}
		
		return strPlotInfo;
	}
	///Jasmine 10/25/05 BOTTOM_PANE_MODIFICATION
	/*
	void addDataset(TreeNode& tr, string strDataset)
	{
		vector<string> vsValues;
		bool flag = getDatasetValues(strDataset, vsValues);
		TreeNode tn=tr.AddNode(strDataset);
		flag = tn.SetAttribute(STR_LABEL_ATTRIB, strDataset);
		tn.strVals = vsValues;				
	}
	bool getDatasetValues(LPCSTR lpcszName, vector<string>& vsValues)
	{
		Dataset ds(lpcszName);
		if(!ds.IsValid())
			return false;
		
		bool bRet = ds.GetStringArray(vsValues);
		return true;		
	}
	*/
	///End BOTTOM_PANE_MODIFICATION
	void show()
	{
		vector<int> vnIndex;
		int nCount = m_vsName.GetSize();
		if(1 > nCount)
			return;
		BeforeUpdate();
		ResetRows();
		AfterUpdate();
		//hide unshown variables on menu command
		vnIndex.Data(0,nCount-1); 		
		if(!m_vnShowProp[PROPERTY_USER])
			hideVars(vnIndex, m_vsProperty, STR_PROPERTY_USER);
		if(!m_vnShowProp[PROPERTY_SYSTEM])
			hideVars(vnIndex, m_vsProperty, STR_PROPERTY_SYSTEM);		
		if(!m_vnShowProp[PROPERTY_SESSION])
			hideVars(vnIndex, m_vsProperty, STR_PROPERTY_SESSION);		
		for(int ii = TYPE_NUMERAL; ii < TYPE_LAST_ITEM; ii++)
		{
			if(!m_vnShowType[ii])
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
				//hideVars(vnIndex, m_vsType, getTypeName(ii));
			{
				if ( TYPE_NUMERAL == ii )
				{
					hideVars(vnIndex, m_vsType, getTypeName(TYPE_DOUBLE));
					hideVars(vnIndex, m_vsType, getTypeName(TYPE_CONST));
					hideVars(vnIndex, m_vsType, getTypeName(TYPE_INT));
				}
				else
				{
					hideVars(vnIndex, m_vsType, getTypeName(ii));
				}
			}
			///---END QA81-14106 IMPROVE_ED_DIALOG
		}

		nCount = vnIndex.GetSize();	
		vector<string> vsShowName, vsShowValue, vsShowType, vsShowSubType, vsShowProperty, vsShowPlotInfo, vsShowDescription;
		vector<string> vsShowScope; ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		for(ii = 0; ii < nCount; ii++)
		{
			vsShowName.Add(m_vsName[vnIndex[ii]]);
			vsShowValue.Add(m_vsValue[vnIndex[ii]]);
			vsShowType.Add(m_vsType[vnIndex[ii]]);
			//vsShowSubType.Add(m_vsSubType[vnIndex[ii]]); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			vsShowProperty.Add(m_vsProperty[vnIndex[ii]]);
			vsShowPlotInfo.Add(m_vsPlotInfo[vnIndex[ii]]);
			vsShowDescription.Add(m_vsDescription[vnIndex[ii]]);
			//vsShowScope.Add(m_vsScope[vnIndex[ii]]); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		}
///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
#ifdef CLEAR_BUTTON
		//set Clear Button status
		bool bEnable = true;
		if(m_vnShowProp[PROPERTY_SYSTEM] && (-1 < vsShowProperty.Find(STR_PROPERTY_SYSTEM)) )
			bEnable = false;
		m_wndDlg.PostMessage(WM_USER_CLEARBTN_ENABLE, bEnable);
#endif CLEAR_BUTTON
///End REMOVE_CLEAR_BUTTON
		//for(ii = 1; ii <= nCount; ii++)
			//SetRowHeading(ii, (string)ii, true);
		
		BeforeUpdate();
		ResetRows();
		SetColumn(LDE_NAME, vsShowName);
		SetColumn(IDE_VALUE, vsShowValue);
		SetColumn(LDE_TYPE, vsShowType);
		//SetColumn(LDE_SUBTYPE, vsShowSubType); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		SetColumn(LDE_PROPERTY, vsShowProperty);
		SetColumn(LDE_PLOT_INFO, vsShowPlotInfo);
		SetColumn(LDE_DESCRIPTION, vsShowDescription);
		//SetColumn(LDE_SCOPE, vsShowScope); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		AfterUpdate();	
		
	}
	void BeforeUpdate()
	{
		SetReady(false);
	}
	void AfterUpdate(bool bResizeCols = true)
	{
		if(bResizeCols)
		{
			SetColAlignments();
			ResizeCols();
		}
		SetReady(true);
	}
	void ResetRows()
	{
		SetRows(0, true);
	}
	void SetColAlignments()
	{
		SetFixedColAlignment(-1, flexAlignCenterCenter);
		SetColAlignment(-1, flexAlignLeftCenter);//flexAlignGeneral);
	}
	bool SetColumn(int nCol, const vector<string>& vsVals)
	{
		return SetColValues(nCol, vsVals, 0, true);
	}
	//hide the variables with strHide
	void hideVars(vector<int>& vnIndex, vector<string> vs, string strHide)
	{
		vector<int> vnTemp;
		int nCount = vnIndex.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			//if(-1 == strHide.Find(vs[vnIndex[ii]],0))
				//vnTemp.Add(vnIndex[ii]);
			// vs[vnIndex[ii]], strHide can be empty, that means none type
			if ( !vs[vnIndex[ii]].IsEmpty() && !strHide.IsEmpty() )
			{
				// String is not equal to String Register, so can't use Find() method
				if( 0 == vs[vnIndex[ii]].CompareNoCase(strHide) )
					continue; // skip hidden vars
			}
			vnTemp.Add(vnIndex[ii]);
			///---END QA81-14106 IMPROVE_ED_DIALOG
		}
		vnIndex = vnTemp;
	}
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/*
	int getDigit(int num, int nOrder = 1)//return the digit of a natural number with assigned order. nOrder > 0
	{
		if(1 > nOrder)
			nOrder = 1;
		int nDivisor = 10^(nOrder-1);
		return (num/nDivisor)%10;
	}
	*/
	///---END QA81-14106 IMPROVE_ED_DIALOG
	void deleteVar(int nRow)
	{
		string strType, strName;
		strType = GetCell(nRow, LDE_TYPE+GetColOffset());
		strName = GetCell(nRow, LDE_NAME+GetColOffset());
		string strProperty = GetCell(nRow, LDE_PROPERTY+GetColOffset()); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG		
		if(!DeleteRow(nRow))
			return;
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//deleteFromSystem(strName, strType);
		deleteFromSystem(strName, strType, strProperty);
		///---END QA81-14106 IMPROVE_ED_DIALOG
		LT_execute("sec -p 0.5");	//force not to update when deleting variables, but it's time-consuming 
		deleteFromDlg(strName, strType);
	}
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	//void deleteFromSystem(string strName, string strType)
	void deleteFromSystem(string strName, string strType, string strProperty = STR_PROPERTY_USER)
	///---END QA81-14106 IMPROVE_ED_DIALOG
	{
		string strLT;
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//if(!strType.CompareNoCase(STR_TYPE_NUMERAL))
		if( !strType.CompareNoCase(STR_TYPE_NUMERAL)
			|| !strType.CompareNoCase(STR_TYPE_DOUBLE)
			|| !strType.CompareNoCase(STR_TYPE_CONST)
			|| !strType.CompareNoCase(STR_TYPE_INT)
			)
		///---END QA81-14106 IMPROVE_ED_DIALOG
		{
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			if ( 0 == strProperty.CompareNoCase(STR_PROPERTY_SESSION) )
				strLT.Format("del -rav %s", strName);
			else
			///---END QA81-14106 IMPROVE_ED_DIALOG
				strLT.Format("del -v %s", strName);
			LT_execute(strLT);
		}
		if(!strType.CompareNoCase(STR_TYPE_STRING))
		{
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			if ( 0 == strProperty.CompareNoCase(STR_PROPERTY_SESSION) )
				strLT.Format("del -ras %s", strName);
			else
			///---END QA81-14106 IMPROVE_ED_DIALOG
				strLT.Format("del -vs %s", strName);
			LT_execute(strLT);
		}
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		if(!strType.CompareNoCase(STR_TYPE_FUNCTION))
		{
			if ( 0 == strProperty.CompareNoCase(STR_PROPERTY_SESSION) )
				strLT.Format("del -raf %s", strName);
			LT_execute(strLT);
		}
		///---END QA81-14106 IMPROVE_ED_DIALOG
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		if(!strType.CompareNoCase(STR_TYPE_MACRO))
		{
			if ( 0 == strProperty.CompareNoCase(STR_PROPERTY_SESSION) )
				strLT.Format("del -m %s", strName);
			LT_execute(strLT);
		}
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		if(!strType.CompareNoCase(STR_TYPE_LOOSEDATASET))
		{
			strLT.Format("del -sd %s",strName);
			LT_execute(strLT);
		}
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		if(!strType.CompareNoCase(STR_TYPE_RANGE))
		{
			if ( 0 == strProperty.CompareNoCase(STR_PROPERTY_SESSION) )
				strLT.Format("del -rar %s", strName);
			LT_execute(strLT);
		}
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		if(!strType.CompareNoCase(STR_TYPE_TREE))
		{
			TreeNode tr;
			bool flag = Project.GetTree(strName, tr);
			if(tr)
				flag = Project.DeleteTree(strName);
		}
	}
	void deleteFromDlg(string strName, string strType)
	{
		if(strName.IsEmpty() || strType.IsEmpty())
			return;
		for(int nFrom = 0; ;)
		{
			int nIndex = m_vsName.Find(strName,nFrom);
			if(-1== nIndex)
				break;
			if(!strType.CompareNoCase(m_vsType[nIndex]))
			{
				if(nIndex < m_vsName.GetSize())
				{
					m_vsName.RemoveAt(nIndex);
					m_vsValue.RemoveAt(nIndex);
					m_vsType.RemoveAt(nIndex);
					m_vsSubType.RemoveAt(nIndex);
					m_vsProperty.RemoveAt(nIndex);
					m_vsPlotInfo.RemoveAt(nIndex);
					m_vsDescription.RemoveAt(nIndex);
					m_vsScope.RemoveAt(nIndex); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
				}
				break;
			}
			nFrom = nIndex+1;
		}
	}
	
	///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	bool is_all_sel_same_class(vector<string> &vsNames, int nType, int nProperty, bool bSupportMulti = false)
	{
		vector<uint> vnSels;
		if( !GetSelRows(vnSels) )
			return false;
		
		int nCount = vnSels.GetSize();
		if ( nCount < 1 )
			return false;
		
		if ( !bSupportMulti && nCount > 1 )
			return false;
		
		vsNames.SetSize(0);
		
		for(int ii = 0; ii < nCount; ii++)
		{
			string strType = GetCell(vnSels[ii], LDE_TYPE+GetColOffset());
			string strProperty = GetCell(vnSels[ii], LDE_PROPERTY+GetColOffset());
			
			if ( 0 == strType.CompareNoCase(getTypeName(nType)) && 0 == strProperty.CompareNoCase(getPropertyName(nProperty)) )
			{
				vsNames.Add(GetCell(vnSels[ii], LDE_NAME+GetColOffset()));
			}
			else
				return false;
		}
		
		return true;			
	}
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	
private:	
    Window			m_wndDlg;
    
	vector<string>	m_vsName;
	vector<string>	m_vsValue;
	vector<string>	m_vsType;		//TYPE_NUMERAL,	TYPE_STRING, TYPE_LOOSEDATASET,	TYPE_TREE
	vector<string>	m_vsSubType;	//Double,Integer,Text etc.
	vector<string>	m_vsProperty;
	vector<string>	m_vsPlotInfo;
	vector<string>	m_vsDescription;
	vector<string>	m_vsScope; ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	
	vector<int>		m_vnShowProp;
	vector<int>		m_vnShowType;
	
	bool			m_bUpdate;
};
///Jasmine 10/21/05 BOTTOM_PANE_MODIFICATION
/*
class LTVarListEditSplitter : public TreeListEditSplitter
{
public:
	LTVarListEditSplitter():TreeListEditSplitter()
	{		
	}
	~LTVarListEditSplitter()
	{
	}
	void OnReady()
	{
		TreeListEditSplitter::OnReady();		
	}
	
	void UpdateDataList(vector<string> vsVars, vector<string> vsTypes)
	{
		int nCount = vsVars.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{		
			if(!vsTypes[ii].CompareNoCase(STR_TYPE_LOOSEDATASET))
			{			
				vector<string> vsValues;
				bool bRet = getDatasetValues(vsVars[ii], vsValues);
				if(bRet)
					UpdateListPane(vsVars[ii], vsValues);
			}		
			if(!vsTypes[ii].CompareNoCase(STR_TYPE_TREE))
			{
				TreeNode tr;
				bool flag = Project.GetTree(vsVars[ii], tr);
				if(flag)
				{
					//m_trSelected = tr;
					UpdateTreePane(tr);
					AddToShowTree(tr);
				}
			}
		}
		ShowTree();
	}
protected:

	
private:
	bool getDatasetValues(LPCSTR lpcszName, vector<string>& vsValues)
	{
		Dataset ds(lpcszName);
		if(!ds.IsValid())
			return false;
		
		bool bRet = ds.GetStringArray(vsValues);
		return true;		
	}
	
private:
	

};
*/
///End BOTTOM_PANE_MODIFICATION

///Jasmine 10/24/05 BOTTOM_PANE_MODIFICATION
class LTDataListControl : public TreeEditControl
{
public:
	LTDataListControl()
	{
	}
	///Jasmine 10/25/05 VALUE_EDITING
	void InitList(int nID, WndContainer& dlg)
	{
		TreeEditControl::Init(nID, false, true, NULL, dlg);
		
		SetEditable();
	}
	///End VALUE_EDITING
	///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	//void UpdateDataList(int nType, const vector<string>& vsVars)
	void UpdateDataList(const vector<string> &vsVars, int nType, int nProperty)
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	{
		switch(nType)
		{
		case TYPE_TREE:
			Tree trVar;
			TreeNode node;
			///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			//bool flag = Project.GetTree(vsVars[0], node);
			bool flag = false;
			if ( PROPERTY_USER == nProperty )
			{
				flag = Project.GetTree(vsVars[0], node);
			}
			else if ( PROPERTY_SESSION == nProperty )
			{
				flag = Project.GetSessionTree(vsVars[0], node);
			}
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
			flag = trVar.AddNode(node, TRUE);
			SetReady(false);
			CreateTreeView();
			SetExtendLastCol(true);	//---- CPY 11/14/05 LOOSE_DATALIST_BETTER_SHOW_WITHOUT_LAST_COL_TOO_WIDE
			/// Iris 06/22/2007 v8.0646 FIX_RUNTIME_ERR_WHEN_SHOW_OPERATION_GUI_TREE, set bCallNodesHandlers from default(true) to false.
			//Update(trVar, true, true);
			Update(trVar, true, true, false);
			/// end FIX_RUNTIME_ERR_WHEN_SHOW_OPERATION_GUI_TREE
			SetCollapsed(0,flexOutlineExpanded);
			SetReady(true);
			break;
		case TYPE_LOOSEDATASET:			
			SetReady(false);
			CreateGridView();
			SetExtendLastCol(false);	//---- CPY 11/14/05 LOOSE_DATALIST_BETTER_SHOW_WITHOUT_LAST_COL_TOO_WIDE
			UpdateGrid(vsVars);
			SetReady(true);
			break;
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		case TYPE_RANGE:
			SetReady(false);
			CreateGridView();
			SetExtendLastCol(true);
			UpdateRange(vsVars);
			SetReady(true);
			break;
		// Sim, to do
		//case TYPE_MACRO:
			//break;
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		/*
		case TYPE_FUNCTION:			
			SetReady(false);
			CreateGridView();
			//SetExtendLastCol(false);	//---- CPY 11/14/05 LOOSE_DATALIST_BETTER_SHOW_WITHOUT_LAST_COL_TOO_WIDE
			UpdateFunction(vsVars);
			SetReady(true);
			break;
		*/
		///---END QA81-14106 IMPROVE_ED_DIALOG
		default:
			ClearAll();
			return;
		}
		return;
	}
	void UpdateGrid(const vector<string>& vsVars)
	{		
		int nCount = vsVars.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{			
			vector<string> vsValues;
			bool bRet = getDatasetValues(vsVars[ii], vsValues);
			if(bRet)
				showDataset(vsVars[ii], vsValues);
		}
	}
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/*
	void UpdateFunction(const vector<string>& vsVars)
	{
		if ( vsVars.GetSize() <= 0 )
			return;
		
		string strFunctionName = vsVars[0];
		string strPrototype, strBody;
		if ( Project.GetFunction(strFunctionName, strPrototype, strBody) )
		{
			showFunction(strFunctionName, strPrototype, strBody);
		}
	}
	*/
	///---END QA81-14106 IMPROVE_ED_DIALOG
	///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	void UpdateRange(const vector<string>& vsVars)
	{
		if ( vsVars.GetSize() <= 0 )
			return;
		
		vector<string> vsLTVarNames, vsLTVarValues;
		Project.GetSessionLTVars(vsLTVarNames, vsLTVarValues, LTVAR_TYPE_VAR_ALIAS);
		
		vector<string> vsColHeaders;
		vsColHeaders.Add(_L("Value"));
		
		vector<string> vsValues;
		vsValues.SetSize(vsVars.GetSize());
		for ( int ii = 0; ii < vsVars.GetSize(); ii++ )
		{
			int nPos = vsLTVarNames.Find(vsVars[ii]);
			if ( nPos >= 0 )
				vsValues[ii] = vsLTVarValues[nPos];
		}
		
		addColumn(_L("Value"), vsValues, vsVars);
	}
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	void ClearAll() 
	{
		m_flx.Rows = 0;
	}
private:
	bool getDatasetValues(LPCSTR lpcszName, vector<string>& vsValues)
	{
		Dataset ds(lpcszName);
		if(!ds.IsValid())
			return false;
		
		bool bRet = ds.GetStringArray(vsValues);
		return true;		
	}
	void showDataset(string strName, vector<string> vs)
	{
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		//addColumn(strName, vs, GetCols());
		addColumn(strName, vs);
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		SetFixedColAlignment(-1, flexAlignCenterCenter);
		SetColAlignment(-1, flexAlignLeftCenter);
	}
	///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	/*
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	//bool addColumn(string strName, const vector<string>& vsList, int nCol = 0)
	bool addColumn(string strName, const vector<string>& vsList, int nCol = 0, const vector<string>& vsRowHeaders = NULL)
	///---END QA81-14106 IMPROVE_ED_DIALOG
	{
		int nFixedRows = GetRowOffset();
		int nSize = vsList.GetSize();
		if(nCol < 0 || nSize == 0)
			return false;
		
		AddCol();
		SetColHeading(nCol-1, strName);
		int nOldRow = GetRows() - nFixedRows;
		if(nOldRow < nSize)
		{
			SetRows(nSize);
			for(int ii = nOldRow+1; ii <= nSize; ii++)
			///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
			{
				//SetRowHeading(ii-1, (string)ii);
				string strRowHeader = ii;
				if ( vsRowHeaders && vsRowHeaders.GetSize() > ii )
					strRowHeader = vsRowHeaders[ii];
				SetRowHeading(ii-1, strRowHeader);
			}
			///---END QA81-14106 IMPROVE_ED_DIALOG
		}
		
		for(int ii = 0; ii < nSize; ii++)
			SetCell(nFixedRows + ii, nCol, vsList[ii]);
		
		return true;
	}
	*/
	bool addColumn(string strName, const vector<string>& vsList, const vector<string>& vsRowHeaders = NULL)
	{
		int nSize = vsList.GetSize();
		if ( nSize <= 0 )
			return false;
		
		AddCol();
		int nCol = GetCols() - 1;
		nCol -= GetColOffset();
		if ( nCol < 0 )
			return false;
		
		SetColHeading(nCol, strName);
		
		int nRows = GetRows();
		nRows -= GetRowOffset();
		if ( nRows < nSize )
		{
			SetRows(nSize);
			for(int ii = nRows+1; ii <= nSize; ii++)
			{
				string strRowHeader = ii;
				if ( vsRowHeaders && vsRowHeaders.GetSize() > (ii-1) )
					strRowHeader = vsRowHeaders[ii-1];
				SetRowHeading(ii-1, strRowHeader);
			}
		}
		
		return SetColValues(nCol, vsList);
	}
	/*
	bool addRow(string strName, const vector<string>& vsList, const vector<string>& vsColHeaders = NULL)
	{
		int nSize = vsList.GetSize();
		if ( nSize <= 0 )
			return false;
		
		int nRow = AddRow();
		nRow -= GetRowOffset();
		if ( nRow < 0 )
			return false;
		
		SetRowHeading(nRow, strName);
		
		int nCols = GetCols();
		nCols -= GetColOffset();
		if ( nCols < nSize )
		{
			SetCols(nSize);
			for(int ii = nCols+1; ii <= nSize; ii++)
			{
				string strColHeader = ii;
				if ( vsColHeaders && vsColHeaders.GetSize() > (ii-1) )
					strColHeader = vsColHeaders[ii-1];
				SetColHeading(ii-1, strColHeader);
			}
		}
		
		return SetRowValues(nRow, vsList);
	}
	*/
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/*
	void showFunction(LPCSTR lpcszName, LPCSTR lpcszPrototype, LPCSTR lpcszBody)
	{
		vector<string> vsRowHeaders, vsList;
		//vsRowHeaders.Add(""); // first row is col header
		vsRowHeaders.Add(_L("Prototype"));
		vsList.Add(lpcszPrototype);
		vsRowHeaders.Add(_L("Body"));
		vsList.Add(lpcszBody);		
		
		addColumn(lpcszName, vsList, GetCols(), vsRowHeaders);
		SetFixedColAlignment(-1, flexAlignCenterCenter);
		SetColAlignment(-1, flexAlignLeftCenter);
	}
	*/
	///---END QA81-14106 IMPROVE_ED_DIALOG
};
///End BOTTOM_PANE_MODIFICATION
///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
class LTDataControl : public Edit
{
public:
	///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	//void Update(const vector<string>& vsVars, int nType)
	void Update(const vector<string>& vsVars, int nType, int nProperty)
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	{
		Text = "";
		
		if ( vsVars.GetSize() <= 0 )
			return;
		
		switch(nType)
		{
		case TYPE_FUNCTION:
			string strFunctionName = vsVars[0];
			string strPrototype, strBody;
			if ( Project.GetFunction(strFunctionName, strPrototype, strBody) )
			{
				string strContent;
				//strContent.Format("%s\r\n{\r\n%s\r\n}\r\n", strPrototype, strBody);
				strContent.Format("%s{%s}", strPrototype, strBody);
				Text = strContent;
			}

			break;
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		case TYPE_MACRO:
			string strMacroName = vsVars[0];

 			vector<string> vsLTVarNames, vsLTVarValues;
			Project.GetMacros(vsLTVarNames, vsLTVarValues);

			int nPos = vsLTVarNames.Find(strMacroName);
			if ( nPos >= 0 )
				Text = vsLTVarValues[nPos];

			break;
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
	}
};
///---END QA81-14106 IMPROVE_ED_DIALOG

class LTVarEditDlg : public MultiPaneDlg
{
public:
	LTVarEditDlg(BOOL bDeleteOnDestroy = true) : MultiPaneDlg(IDD_LTVAR_DLG, "ODlg8")
	{
		m_bDeleteOnDestroy = bDeleteOnDestroy;
	}	
	~LTVarEditDlg()
	{
	}
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		return DoModal(hWndParent);
	}
	
	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//Launch the modeless dialog
		int nRet = MultiPaneDlg::Create(hParent);
		Visible=true;
		
		return nRet;
	}
	
	void Update(LPCSTR lpcszMsg = NULL)
	{
		if(lpcszMsg) // debug message
			printf("dialog update from %s\n", lpcszMsg);		
	}	
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)	///Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	//ON_RESTORESIZE(OnRestoreSize) ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	//ON_CONTEXTMENU(OnShowMenu)
	///---END QA81-14106 IMPROVE_ED_DIALOG
	ON_GRID_SEL_CHANGE(IDC_VAR_LIST, OnRowChange)
	///Jasmine 10/25/05 VALUE_EDITING
	ON_GRID_BEFORE_EDIT(IDC_VAR_LIST, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_VAR_LIST, OnAfterEdit)
	ON_GRID_DBLCLICK(IDC_VAR_LIST, OnDblClick)
	///End VALUE_EDITING
	ON_BN_CLICKED(IDC_LTVAR_SHOW_DATA_BTN, OnShowData)
///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
#ifdef CLEAR_BUTTON	
	ON_BN_CLICKED(IDC_CLEAR_BTN, OnClear)
#endif CLEAR_BUTTON
///End REMOVE_CLEAR_BUTTON	
	ON_BN_CLICKED(IDC_DEL_BTN, OnDelete)
	ON_ORIGIN_MSG(SN_LOOSE_DATASET_CHANGE, OnLooseDatasetChange)
	//---- CPY QA70-7860 10/14/05 LT_VARS_EDIT_UPDATE
	ON_ORIGIN_MSG(SN_LT_USR_NUMERIC_VAR_CHANGE, OnUserNumericVarChange)
	ON_ORIGIN_MSG(SN_LT_USR_STR_VAR_CHANGE, OnUserStrVarChange)
	ON_ORIGIN_MSG(SN_LT_TREE_VAR_CHANGE, OnTreeVarChange)
	//---- end LT_VARS_EDIT_UPDATE
	///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	// Sim, to do.
	// RANGE, MACRO
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
#ifdef CLEAR_BUTTON
	ON_USER_MSG(WM_USER_CLEARBTN_ENABLE, OnClearButtonEnable)
#endif CLEAR_BUTTON
///End REMOVE_CLEAR_BUTTON
	ON_USER_MSG(WM_USER_DELETEBTN_ENABLE, OnDeleteButtonEnable)
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	ON_BN_CLICKED(IDC_DISP_USER, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_SYSTEM, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_SESSION, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_NUMERIC, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_STRING, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_STRING_REG, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_FUNCTION, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_LOOSE_DATASET, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_TREE, OnShowListCheckChange)
	///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	ON_BN_CLICKED(IDC_DISP_RANGE, OnShowListCheckChange)
	ON_BN_CLICKED(IDC_DISP_MACRO, OnShowListCheckChange)
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	
	ON_BN_CLICKED(IDC_UPDATE_BTN, OnUpdate)
	///---END QA81-14106 IMPROVE_ED_DIALOG
EVENTS_END

//------------ Event Handlers ------------------------
	BOOL OnInitDialog()
	{
		waitCursor junk;
		
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Values");
		vstrTipsUpDown[1] = _L("Hide Values");
		MultiPaneDlg::OnInitDialog(IDC_VAR_LIST, IDC_LTVAR_SHOW_DATA_BTN, IDC_DATA_LIST_BOX, vstrTipsUpDown, STR_DLG_NAME, 0, NULL, false);	//true to open bottom pane, false to close
				
    	m_VarList.InitList(IDC_VAR_LIST, *this);
    	//m_DataList.Init(IDC_DATA_LIST_BOX, *this, STR_DLG_NAME);  ///Jasmine 10/21/05 BOTTOM_PANE_MODIFICATION 	
		//m_DataList.Init(IDC_DATA_LIST_BOX, false, true, NULL, *this);///Jasmine 10/25/05 VALUE_EDITING
    	m_DataList.InitList(IDC_DATA_LIST_BOX, *this);
    	m_DataView = GetItem(IDC_DATA_EDIT_BOX); ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG

		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	    //m_strShowStatus = "VarListShowStatus";
		//m_nShowStatus = LoadSetting(m_strShowStatus, 011111, STR_DLG_NAME);//temp
		//m_VarList.SetVarListShowStatus(m_nShowStatus);
		updateVarListShowStatusRegister(true); // from register
		updateVarListShowStatusCheckBoxes(false); // to checkbox
		OnEnableShowListCheck();
		///---END QA81-14106 IMPROVE_ED_DIALOG
    	
    	//inti dialog
	    
	    m_nSelRow = -1;
	    
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//GetItem(IDC_UPDATE_BTN).Visible = false;
		GetItem(IDC_DATA_EDIT_BOX).Visible = false;
		///---END QA81-14106 IMPROVE_ED_DIALOG
		
		//UpdateDlgSize();		
		//UpdateDlgShow();
		//SetInitReady();		   
		return true;
	}
	///Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY
	BOOL OnReady()
	{	
		m_VarList.Update();
		//m_DataList.OnReady();	///Jasmine 10/21/05 BOTTOM_PANE_MODIFICATION
	
		UpdateDlgSize();		
		UpdateDlgShow();			
		SetInitReady();		
		return true;
	}
	///End SPLITTER_INIT_SIZE_ON_READY
	BOOL OnDestroy(); //CPY 10/13/05 added m_bDeleteOnDestroy
		
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		//uint nButtonIDs[] = {IDC_CLEAR_BTN, IDC_DEL_BTN, IDOK, 0};///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//uint nButtonIDs[] = {IDC_DEL_BTN, IDOK, 0};
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		//uint nButtonIDs[] = {IDC_DEL_BTN, IDC_UPDATE_BTN, IDOK, IDC_DISP_SYSTEM, IDC_DISP_USER, IDC_DISP_SESSION, IDC_DISP_SEPARATOR, IDC_DISP_NUMERIC, IDC_DISP_STRING, IDC_DISP_STRING_REG, IDC_DISP_FUNCTION, IDC_DISP_LOOSE_DATASET, IDC_DISP_TREE, 0};
		uint nButtonIDs[] = {IDC_DEL_BTN, IDC_UPDATE_BTN, IDOK, IDC_DISP_SYSTEM, IDC_DISP_USER, IDC_DISP_SESSION, IDC_DISP_SEPARATOR, IDC_DISP_NUMERIC, IDC_DISP_STRING, IDC_DISP_STRING_REG, IDC_DISP_FUNCTION, IDC_DISP_LOOSE_DATASET, IDC_DISP_TREE, IDC_DISP_RANGE, IDC_DISP_MACRO, 0};
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		///---END QA81-14106 IMPROVE_ED_DIALOG
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy);		
		
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		RECT rr;
		GetClientRect(GetItem(IDC_DATA_LIST_BOX), rr);
		MoveControl(GetItem(IDC_DATA_EDIT_BOX), rr);
		///---END QA81-14106 IMPROVE_ED_DIALOG
			
		return TRUE;
	}
	
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/*
	BOOL OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	
		lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
				
		pSz->top = -1;
		pSz->left = - 1;
		pSz->width = 400;
		pSz->height = 600;
		return TRUE;
	}
	*/
	///---END QA81-14106 IMPROVE_ED_DIALOG
	
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/*
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if(IDC_VAR_LIST == nResIDCtrl)
			return m_VarList.OnCmdWndMenu(nx, ny);
					
		return FALSE;
	}
	*/
	///---END QA81-14106 IMPROVE_ED_DIALOG
	void OnRowChange(Control ctrl)
	{
		if(!IsInitReady() || !m_VarList.IsReady())
			return;
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		/*
		///Jasmine 10/20/05 BOTTOM_PANE_MODIFICATION
		/#
		m_DataList.CleanDataList();	
				
		vector<string> vsVars, vsTypes;		
		m_VarList.RowChange(vsVars, vsTypes);
		//--- CPY 10/13/05 LTVAR_DLG_COMPILE_PROBLEM
		//m_DataList.OnUpdateDataList(vsVars, vsTypes);
		//---
		m_DataList.UpdateDataList(vsVars, vsTypes);//in LTVarListEditSplitter
		#/
		vector<string> vsVars;
		int nType = m_VarList.CheckSelVar(vsVars);
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		//m_DataList.UpdateDataList(nType, vsVars);
		if ( TYPE_FUNCTION == nType )
		{
			GetItem(IDC_DATA_LIST_BOX).Visible = false;
			GetItem(IDC_DATA_EDIT_BOX).Visible = true;
			m_DataView.Update(vsVars);
		}
		else
		{
			GetItem(IDC_DATA_LIST_BOX).Visible = true;
			GetItem(IDC_DATA_EDIT_BOX).Visible = false;
			m_DataList.UpdateDataList(nType, vsVars);
		}
		///---END QA81-14106 IMPROVE_ED_DIALOG
		return;
		///End BOTTOM_PANE_MODIFICATION
		*/
		BOOL bSystemVar;
		vector<string> vsVars;
		///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		//int nType = m_VarList.CheckSelVar(vsVars, &bSystemVar);
		//
		//if ( IsBottomPaneShown() )
			//updateDataList(vsVars, nType);
		//
		//PostMessage(WM_USER_DELETEBTN_ENABLE, !bSystemVar);
		
		if ( IsBottomPaneShown() )
		{
			int nProperty;
			int nType = m_VarList.CheckSelVar(vsVars, &nProperty);
			updateDataList(vsVars, nType, nProperty);
		}
		
		PostMessage(WM_USER_DELETEBTN_ENABLE, !(m_VarList.IsSystemVarSelected()));
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		///---END QA81-14106 IMPROVE_ED_DIALOG
	}
	///Jasmine 10/25/05 VALUE_EDITING
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		
	}
	void OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		
	}
	void OnDblClick(Control flxControl)
	{
		
	}
	///End VALUE_EDITING
	BOOL OnShowData(Control cntrl)
	{
		MultiPaneDlg::OnShowBottomPane(cntrl);			

		//if the selected data type is tree, then update tree view by function UpdateShowTree
		//if(IsBottomPaneShown())				
			//m_DataList.UpdateShowTree(m_trSelected);		
		
		///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
		RECT rr;
		GetClientRect(GetItem(IDC_DATA_LIST_BOX), rr);
		MoveControl(GetItem(IDC_DATA_EDIT_BOX), rr);
		
		if ( IsBottomPaneShown() )
		{
			vector<string> vsVars;
			///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			//int nType = m_VarList.CheckSelVar(vsVars);
			//updateDataList(vsVars, nType);
			int nProperty;
			int nType = m_VarList.CheckSelVar(vsVars, &nProperty);
			updateDataList(vsVars, nType, nProperty);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
		///---END QA81-14106 IMPROVE_ED_DIALOG
		
		return TRUE;
	}
///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
#ifdef CLEAR_BUTTON
	BOOL OnClear(Control cntrl)//need to set btn status...
	{
		if(!IsInitReady() || !m_VarList.IsReady())
			return FALSE;
		
		m_VarList.ClearVars();
		//m_DataList.CleanDataList();	///Jasmine 10/20/05 BOTTOM_PANE_MODIFICATION
		m_DataList.ClearAll();
		
		return TRUE;
	}
#endif CLEAR_BUTTON
///End REMOVE_CLEAR_BUTTON
	BOOL OnDelete(Control cntrl)
	{
		if(!IsInitReady() || !m_VarList.IsReady())
			return FALSE;
		
		m_VarList.DeleteVars();
		//m_DataList.CleanDataList();	///Jasmine 10/20/05 BOTTOM_PANE_MODIFICATION
		m_DataList.ClearAll();
		
		return TRUE;
	}
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	BOOL OnUpdate(Control cntrl)
	{
		m_VarList.Update();
		return true;
	}
	///---END QA81-14106 IMPROVE_ED_DIALOG
	BOOL OnLooseDatasetChange(int wParam, int lParam)
	{
		m_VarList.Update(TYPE_LOOSEDATASET);
		return TRUE;
	}
	//--- CPY QA70-7860 10/14/05 LT_VARS_EDIT_UPDATE
	BOOL OnUserNumericVarChange(int wParam, int lParam)
	{
		m_VarList.Update(TYPE_NUMERAL);
		///---Sim 08-31-2009 QA81-14106 FIX_ADD_NEW_LT_STR_VAR_NO_UPDATE_ED_DIALOG
		// temperory fix, as SN_LT_USR_STR_VAR_CHANGE not invoked when add new LT str var
		m_VarList.Update(TYPE_STRING); 
		///---END QA81-14106 FIX_ADD_NEW_LT_STR_VAR_NO_UPDATE_ED_DIALOG
		return TRUE;
	}
	BOOL OnUserStrVarChange(int wParam, int lParam)
	{
		m_VarList.Update(TYPE_STRING);
		return TRUE;
	}
	BOOL OnTreeVarChange(int wParam, int lParam)
	{
		m_VarList.Update(TYPE_TREE);
		return TRUE;
	}
	//----
///Jasmine 10/24/05 REMOVE_CLEAR_BUTTON
#ifdef CLEAR_BUTTON
	void OnClearButtonEnable(bool bEnable = false, uint lParam = false)
	{
		setButtonStatus(IDC_CLEAR_BTN, bEnable);
	}
#endif CLEAR_BUTTON
///End REMOVE_CLEAR_BUTTON
	void OnDeleteButtonEnable(bool bEnable = false, uint lParam = false)
	{
		setButtonStatus(IDC_DEL_BTN, bEnable);
	}

	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	BOOL OnShowListCheckChange(Control cntrl)
	{
		updateVarListShowStatusCheckBoxes(true); // from checkbox
		m_VarList.UpdateShow();
		OnEnableShowListCheck();
		return TRUE;
	}	
	
	void OnEnableShowListCheck()
	{
		Button btn;
		
		btn = GetItem(IDC_DISP_SYSTEM);
		bool bSystem	= btn.Check;
		
		btn = GetItem(IDC_DISP_USER);		
		bool bProject	= btn.Check;
		
		btn = GetItem(IDC_DISP_SESSION);
		bool bSession	= btn.Check;
		
		GetItem(IDC_DISP_NUMERIC).Enable		= ( bSystem || bProject || bSession );
		GetItem(IDC_DISP_STRING).Enable			= ( bSystem || bProject || bSession );
		GetItem(IDC_DISP_LOOSE_DATASET).Enable	= ( bProject );
		GetItem(IDC_DISP_TREE).Enable			= ( bProject || bSession );
		GetItem(IDC_DISP_STRING_REG).Enable		= ( bSystem );
		GetItem(IDC_DISP_FUNCTION).Enable		= ( bSession );
		GetItem(IDC_DISP_RANGE).Enable			= ( bSession );
		GetItem(IDC_DISP_MACRO).Enable			= ( bSession );
	}
	///---END QA81-14106 IMPROVE_ED_DIALOG
	
private:
	void setButtonStatus(uint nButtonID, bool bEnable = true)
	{
		Button btn=GetItem(nButtonID);
		btn.Enable=bEnable;
	}
	
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	void updateVarListShowStatusRegister(bool bFromRegister)
	{
		if ( bFromRegister ) // Load
		{
			int nCategory;
			
			nCategory = SHOW_STATUS_PROPERTY;
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("User"),			TRUE,	STR_DLG_NAME), PROPERTY_USER,	nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("System"),			FALSE,	STR_DLG_NAME), PROPERTY_SYSTEM,	nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("Session"),			TRUE,	STR_DLG_NAME), PROPERTY_SESSION,	nCategory);
			
			nCategory = SHOW_STATUS_TYPE;
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("Numeric"),			TRUE,	STR_DLG_NAME), TYPE_NUMERAL,	nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("String"),			TRUE,	STR_DLG_NAME), TYPE_STRING,		nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("LooseDataset"),	TRUE,	STR_DLG_NAME), TYPE_LOOSEDATASET,	nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("Tree"),			TRUE,	STR_DLG_NAME), TYPE_TREE,		nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("StringRegister"),	FALSE,	STR_DLG_NAME), TYPE_STRING_REG,	nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("Function"),		TRUE,	STR_DLG_NAME), TYPE_FUNCTION,	nCategory);
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("DataRange"),		TRUE,	STR_DLG_NAME), TYPE_RANGE,		nCategory);
			m_VarList.SetVarListShowStatus(LoadSetting(STR_SHOW_LIST_STATUS("Macro"),			FALSE,	STR_DLG_NAME), TYPE_MACRO,		nCategory);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
		else // Save
		{
			int nCategory;
			
			nCategory = SHOW_STATUS_PROPERTY;
			SaveSetting(STR_SHOW_LIST_STATUS("User"),			m_VarList.GetVarListShowStatus(PROPERTY_USER,		nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("System"),			m_VarList.GetVarListShowStatus(PROPERTY_SYSTEM,		nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("Session"),		m_VarList.GetVarListShowStatus(PROPERTY_SESSION,	nCategory),		STR_DLG_NAME);
			
			nCategory = SHOW_STATUS_TYPE;
			SaveSetting(STR_SHOW_LIST_STATUS("Numeric"),		m_VarList.GetVarListShowStatus(TYPE_NUMERAL,		nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("String"),			m_VarList.GetVarListShowStatus(TYPE_STRING,			nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("LooseDataset"),	m_VarList.GetVarListShowStatus(TYPE_LOOSEDATASET,	nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("Tree"),			m_VarList.GetVarListShowStatus(TYPE_TREE,			nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("StringRegister"),	m_VarList.GetVarListShowStatus(TYPE_STRING_REG,		nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("Function"),		m_VarList.GetVarListShowStatus(TYPE_FUNCTION,		nCategory),		STR_DLG_NAME);
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			SaveSetting(STR_SHOW_LIST_STATUS("DataRange"),		m_VarList.GetVarListShowStatus(TYPE_RANGE,			nCategory),		STR_DLG_NAME);
			SaveSetting(STR_SHOW_LIST_STATUS("Macro"),			m_VarList.GetVarListShowStatus(TYPE_MACRO,			nCategory),		STR_DLG_NAME);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
	}
	
	void updateVarListShowStatusCheckBoxes(bool bFromCheckBoxes)
	{
		Button btn;
		if ( bFromCheckBoxes )
		{
			int nCategory;
			
			nCategory = SHOW_STATUS_PROPERTY;
			btn = GetItem(IDC_DISP_USER);			m_VarList.SetVarListShowStatus(btn.Check,		PROPERTY_USER,		nCategory);
			btn = GetItem(IDC_DISP_SYSTEM);			m_VarList.SetVarListShowStatus(btn.Check,		PROPERTY_SYSTEM,	nCategory);
			btn = GetItem(IDC_DISP_SESSION);		m_VarList.SetVarListShowStatus(btn.Check,		PROPERTY_SESSION,	nCategory);
			
			nCategory = SHOW_STATUS_TYPE;
			btn = GetItem(IDC_DISP_NUMERIC);		m_VarList.SetVarListShowStatus(btn.Check,		TYPE_NUMERAL,		nCategory);
			btn = GetItem(IDC_DISP_STRING);			m_VarList.SetVarListShowStatus(btn.Check,		TYPE_STRING,		nCategory);
			btn = GetItem(IDC_DISP_LOOSE_DATASET);	m_VarList.SetVarListShowStatus(btn.Check, 		TYPE_LOOSEDATASET,	nCategory);
			btn = GetItem(IDC_DISP_TREE);			m_VarList.SetVarListShowStatus(btn.Check,		TYPE_TREE,			nCategory);
			btn = GetItem(IDC_DISP_STRING_REG);		m_VarList.SetVarListShowStatus(btn.Check,		TYPE_STRING_REG,	nCategory);
			btn = GetItem(IDC_DISP_FUNCTION);		m_VarList.SetVarListShowStatus(btn.Check,		TYPE_FUNCTION,		nCategory);
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			btn = GetItem(IDC_DISP_RANGE);			m_VarList.SetVarListShowStatus(btn.Check,		TYPE_RANGE,			nCategory);
			btn = GetItem(IDC_DISP_MACRO);			m_VarList.SetVarListShowStatus(btn.Check,		TYPE_MACRO,			nCategory);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
		else // to check box
		{
			int nCategory;
			
			nCategory = SHOW_STATUS_PROPERTY;
			btn = GetItem(IDC_DISP_USER);			btn.Check = m_VarList.GetVarListShowStatus(PROPERTY_USER,		nCategory);
			btn = GetItem(IDC_DISP_SYSTEM);			btn.Check = m_VarList.GetVarListShowStatus(PROPERTY_SYSTEM,		nCategory);
			btn = GetItem(IDC_DISP_SESSION);		btn.Check = m_VarList.GetVarListShowStatus(PROPERTY_SESSION,	nCategory);
			
			nCategory = SHOW_STATUS_TYPE;
			btn = GetItem(IDC_DISP_NUMERIC);		btn.Check = m_VarList.GetVarListShowStatus(TYPE_NUMERAL,		nCategory);
			btn = GetItem(IDC_DISP_STRING);			btn.Check = m_VarList.GetVarListShowStatus(TYPE_STRING,			nCategory);
			btn = GetItem(IDC_DISP_LOOSE_DATASET);	btn.Check = m_VarList.GetVarListShowStatus(TYPE_LOOSEDATASET,	nCategory);
			btn = GetItem(IDC_DISP_TREE);			btn.Check = m_VarList.GetVarListShowStatus(TYPE_TREE,			nCategory);
			btn = GetItem(IDC_DISP_STRING_REG);		btn.Check = m_VarList.GetVarListShowStatus(TYPE_STRING_REG,		nCategory);
			btn = GetItem(IDC_DISP_FUNCTION);		btn.Check = m_VarList.GetVarListShowStatus(TYPE_FUNCTION,		nCategory);
			///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			btn = GetItem(IDC_DISP_RANGE);			btn.Check = m_VarList.GetVarListShowStatus(TYPE_RANGE,			nCategory);
			btn = GetItem(IDC_DISP_MACRO);			btn.Check = m_VarList.GetVarListShowStatus(TYPE_MACRO,			nCategory);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
	}
	
	///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	//void updateDataList(vector<string> &vsVars, int nType)
	void updateDataList(vector<string> &vsVars, int nType, int nProperty)
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
	{
		//vector<string> vsVars;
		//int nType = m_VarList.CheckSelVar(vsVars);
		///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
		//if ( TYPE_FUNCTION == nType )
		if ( TYPE_FUNCTION == nType || TYPE_MACRO == nType )
		///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		{
			GetItem(IDC_DATA_LIST_BOX).Visible = false;
			GetItem(IDC_DATA_EDIT_BOX).Visible = true;
			///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			//m_DataView.Update(vsVars, nType);
			m_DataView.Update(vsVars, nType, nProperty);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
		else
		{
			GetItem(IDC_DATA_LIST_BOX).Visible = true;
			GetItem(IDC_DATA_EDIT_BOX).Visible = false;
			///---Sim 09-24-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
			//m_DataList.UpdateDataList(nType, vsVars);
			m_DataList.UpdateDataList(vsVars, nType, nProperty);
			///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG
		}
	}
	///---END QA81-14106 IMPROVE_ED_DIALOG
	
private:
	bool							m_bDeleteOnDestroy; //CPY 10/13/05
	LTVarListControl				m_VarList;
	//LTVarListEditSplitter			m_DataList;	///Jasmine 10/20/05 BOTTOM_PANE_MODIFICATION
	LTDataListControl				m_DataList;
	LTDataControl					m_DataView; ///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	//Tree							m_trSelected;		//if selected data type is tree, then it is valid, else invalid.
	int								m_nSelRow;
	string 							m_strShowStatus;
	int								m_nShowStatus;
};
